<?php if(count(get_included_files()) == 1) exit("No direct script access allowed");

require_once(ABSPATH . 'wp-admin/includes/file.php');

define("TVC_API_DEBUG", false);

define("TVC_TEXT_CONNECTION_FAILED", 'O servidor não está disponível no momento. Tente novamente.');
define("TVC_TEXT_INVALID_RESPONSE", 'O servidor retornou uma resposta inválida. Entre em contato com o suporte.');
define("TVC_TEXT_VERIFIED_RESPONSE", 'Verificado! Obrigado por comprar.');
define("TVC_TEXT_PREPARING_MAIN_DOWNLOAD", 'Preparando para baixar a atualização principal...');
define("TVC_TEXT_MAIN_UPDATE_SIZE", 'Tamanho da atualização principal:');
define("TVC_TEXT_DONT_REFRESH", '(Por favor, não atualize a página).');
define("TVC_TEXT_DOWNLOADING_MAIN", 'Baixando a atualização principal...');
define("TVC_TEXT_UPDATE_PERIOD_EXPIRED", 'Seu período de atualização terminou ou sua licença é inválida. Entre em contato com o suporte.');
define("TVC_TEXT_UPDATE_PATH_ERROR", 'A pasta não tem permissão de gravação ou o caminho do arquivo de atualização não pôde ser resolvido. Entre em contato com o suporte.');
define("TVC_TEXT_MAIN_UPDATE_DONE", 'Principais arquivos de atualização baixados e extraídos.');
define("TVC_TEXT_UPDATE_EXTRACTION_ERROR", 'A atualização da extração do zip falhou.');
define("TVC_TEXT_PREPARING_SQL_DOWNLOAD", 'Preparando para baixar a atualização do SQL...');
define("TVC_TEXT_SQL_UPDATE_SIZE", 'Tamanho da atualização do SQL:');
define("TVC_TEXT_DOWNLOADING_SQL", 'Fazendo o download da atualização do SQL...');
define("TVC_TEXT_SQL_UPDATE_DONE", 'Arquivos de atualização SQL baixados.');
define("TVC_TEXT_UPDATE_WITH_SQL_DONE", 'O aplicativo foi atualizado com sucesso, por favor importe o arquivo SQL baixado em seu banco de dados manualmente.');
define("TVC_TEXT_UPDATE_WITHOUT_SQL_DONE", 'O aplicativo foi atualizado com sucesso, não houve atualizações de SQL.');

class RadioTVBoxAPI{

	private $product_id;
	private $api_url;
	private $api_key;
	private $api_language;
	private $current_version;
	private $verify_type;
	private $verification_period;
	private $current_path;
	private $root_path;
	private $license_file;

public function __construct(){ 
		$this->product_id = '5CA70177';
		$this->api_url = 'https://license.signagehost.com/';
		$this->api_key = '001FDFDB60F2918A3A74';
		$this->api_language = 'portuguese';
		$this->current_version = '1.9.9';
		$this->verify_type = 'non_envato';
		$this->verification_period = 7;
		$this->current_path = realpath(__DIR__);
		$this->root_path = realpath($this->current_path.'/..');
		$this->license_file = $this->current_path.'/.lic';
	}

	public function check_local_license_exist(){
		return is_file($this->license_file);
	}

	public function get_current_version(){
		return $this->current_version;
	}

	private function init_wp_fs(){
		global $wp_filesystem;
		if(false === ($credentials = request_filesystem_credentials(''))){
			return false;
		}
		if(!WP_Filesystem($credentials)){ 
			request_filesystem_credentials('');
			return false;
		}
		return true;
	}

	private function write_wp_fs($file_path, $content){
		global $wp_filesystem;
		$save_file_to = $file_path;
		if($this->init_wp_fs()){    
			if($wp_filesystem->put_contents($save_file_to, $content, FS_CHMOD_FILE)){
				return true;
			}
			else{
				return false;
			}
		}
	}

	private function read_wp_fs($file_path){
		global $wp_filesystem;
		if($this->init_wp_fs()){    
			return $wp_filesystem->get_contents($file_path);
		}
	}

	private function call_api($method, $url, $data){
		$wp_args = array('body' => $data);	
		$wp_args['method'] = $method;

		$this_url = site_url();
		$this_ip = getenv('SERVER_ADDR')?:
			$this->get_ip_from_third_party()?:
			gethostbyname(gethostname());

		$wp_args['headers'] = array(
			'Content-Type' => 'application/json', 
			'LB-API-KEY' => $this->api_key, 
			'LB-URL' => $this_url, 
			'LB-IP' => $this_ip, 
			'LB-LANG' => $this->api_language
		);
		$wp_args['timeout'] = 30;

		$result = wp_remote_request($url, $wp_args);

		if(is_wp_error($result)&&!TVC_API_DEBUG){
			$rs = array(
				'status' => FALSE, 
				'message' => TVC_TEXT_CONNECTION_FAILED
			);
			return json_encode($rs);
		}
		$http_status = $result['response']['code'];
		if($http_status != 200){
			if(TVC_API_DEBUG){
				$temp_decode = json_decode($result['body'], true);
				$rs = array(
					'status' => FALSE, 
					'message' => ((!empty($temp_decode['error']))?
						$temp_decode['error']:
						$temp_decode['message'])
				);
				return json_encode($rs);
			}else{
				$rs = array(
					'status' => FALSE, 
					'message' => TVC_TEXT_INVALID_RESPONSE
				);
				return json_encode($rs);
			}
		}
		return $result['body'];
	}

	public function check_connection(){
		$data_array =  array();
		$get_data = $this->call_api(
			'POST',
			$this->api_url.'api/check_connection_ext', 
			json_encode($data_array)
		);
		$response = json_decode($get_data, true);
		return $response;
	}

	public function get_latest_version(){
		$data_array =  array(
			"product_id"  => $this->product_id
		);
		$get_data = $this->call_api(
			'POST',
			$this->api_url.'api/latest_version', 
			json_encode($data_array)
		);
		$response = json_decode($get_data, true);
		return $response;
	}

	public function activate_license($license, $client, $create_lic = true){
		$data_array =  array(
			"product_id"  => $this->product_id,
			"license_code" => $license,
			"client_name" => $client,
			"verify_type" => $this->verify_type
		);
		$get_data = $this->call_api(
			'POST',
			$this->api_url.'api/activate_license', 
			json_encode($data_array)
		);
		$response = json_decode($get_data, true);
		if(!empty($create_lic)){
			if($response['status']){
				$licfile = trim($response['lic_response']);
				$this->write_wp_fs($this->license_file, $licfile);
			}else{
				if(is_writeable($this->license_file)){
					unlink($this->license_file);
				}
			}
		}
		return $response;
	}

	public function verify_license($time_based_check = false, $license = false, $client = false){
		if(!empty($license)&&!empty($client)){
			$data_array =  array(
				"product_id"  => $this->product_id,
				"license_file" => null,
				"license_code" => $license,
				"client_name" => $client
			);
		}else{
			if(is_file($this->license_file)){
				$data_array =  array(
					"product_id"  => $this->product_id,
					"license_file" => $this->read_wp_fs($this->license_file),
					"license_code" => null,
					"client_name" => null
				);
			}else{
				$data_array =  array();
			}
		} 
		$res = array('status' => TRUE, 'message' => TVC_TEXT_VERIFIED_RESPONSE);
		if($time_based_check && $this->verification_period > 0){
			ob_start();
			if(session_status() == PHP_SESSION_NONE){
				session_start();
			}
			$type = (int) $this->verification_period;
			$today = date('d-m-Y');
			if(empty($_SESSION["da2a27bccd6dd0b"])){
				$_SESSION["da2a27bccd6dd0b"] = '00-00-0000';
			}
			if($type == 1){
				$type_text = '1 day';
			}elseif($type == 3){
				$type_text = '3 days';
			}elseif($type == 7){
				$type_text = '1 week';
			}elseif($type == 30){
				$type_text = '1 month';
			}elseif($type == 90){
				$type_text = '3 months';
			}elseif($type == 365) {
				$type_text = '1 year';
			}else{
				$type_text = $type.' days';
			}
			if(strtotime($today) >= strtotime($_SESSION["da2a27bccd6dd0b"])){
				$get_data = $this->call_api(
					'POST',
					$this->api_url.'api/verify_license', 
					json_encode($data_array)
				);
				$res = json_decode($get_data, true);
				if($res['status']==true){
					$tomo = date('d-m-Y', strtotime($today. ' + '.$type_text));
					$_SESSION["da2a27bccd6dd0b"] = $tomo;
				}
			}
			ob_end_clean();
		}else{
			$get_data = $this->call_api(
				'POST',
				$this->api_url.'api/verify_license', 
				json_encode($data_array)
			);
			$res = json_decode($get_data, true);
		}
		return $res;
	}

	public function deactivate_license($license = false, $client = false){
		if(!empty($license)&&!empty($client)){
			$data_array =  array(
				"product_id"  => $this->product_id,
				"license_file" => null,
				"license_code" => $license,
				"client_name" => $client
			);
		}else{
			if(is_file($this->license_file)){
				$data_array =  array(
					"product_id"  => $this->product_id,
					"license_file" => $this->read_wp_fs($this->license_file),
					"license_code" => null,
					"client_name" => null
				);
			}else{
				$data_array =  array();
			}
		}
		$get_data = $this->call_api(
			'POST',
			$this->api_url.'api/deactivate_license', 
			json_encode($data_array)
		);
		$response = json_decode($get_data, true);
		if($response['status']){
			if(is_writeable($this->license_file)){
				unlink($this->license_file);
			}
		}
		return $response;
	}

	public function check_update(){
		$data_array =  array(
			"product_id"  => $this->product_id,
			"current_version" => $this->current_version
		);
		$get_data = $this->call_api(
			'POST',
			$this->api_url.'api/check_update', 
			json_encode($data_array)
		);
		$response = json_decode($get_data, true);
		return $response;
	}

	public function download_update($update_id, $type, $version, $license = false, $client = false){ 
		if(!empty($license)&&!empty($client)){
			$data_array =  array(
				"license_file" => null,
				"license_code" => $license,
				"client_name" => $client
			);
		}else{
			if(is_file($this->license_file)){
				$data_array =  array(
					"license_file" => $this->read_wp_fs($this->license_file),
					"license_code" => null,
					"client_name" => null
				);
			}else{
				$data_array =  array();
			}
		}
		ob_end_flush(); 
		ob_implicit_flush(true);  
		$version = str_replace(".", "_", $version);
		ob_start();
		$source_size = $this->api_url."api/get_update_size/main/".$update_id; 
		echo TVC_TEXT_PREPARING_MAIN_DOWNLOAD."<br>";
		ob_flush();
		echo TVC_TEXT_MAIN_UPDATE_SIZE." ".$this->get_remote_filesize($source_size)." ".TVC_TEXT_DONT_REFRESH."<br>";
		ob_flush();
		$temp_progress = '';
		$source = $this->api_url."api/download_update/main/".$update_id; 
		$wp_args = array('body' => json_encode($data_array));	
		$wp_args['method'] = 'POST';
		$this_url = site_url();
		$this_ip = getenv('SERVER_ADDR')?:
			$this->get_ip_from_third_party()?:
			gethostbyname(gethostname());
		$wp_args['headers'] = array(
			'Content-Type' => 'application/json', 
			'LB-API-KEY' => $this->api_key, 
			'LB-URL' => $this_url, 
			'LB-IP' => $this_ip, 
			'LB-LANG' => $this->api_language
		);
		$wp_args['timeout'] = 30;
		echo TVC_TEXT_DOWNLOADING_MAIN."<br>";
		ob_flush();
		$result = wp_remote_request($source, $wp_args);
		if(is_wp_error($result)){
			exit("<br>".TVC_TEXT_CONNECTION_FAILED);
		}
		$data = $result['body'];
		$http_status = $result['response']['code'];
		if($http_status != 200){
			if($http_status == 401){
				exit("<br>".TVC_TEXT_UPDATE_PERIOD_EXPIRED);
			}else{
				exit("<br>".TVC_TEXT_INVALID_RESPONSE);
			}
		}
		$destination = $this->root_path."/update_main_".$version.".zip"; 
		$file = $this->write_wp_fs($destination, $data);
		if(!$file){
			exit("<br>".TVC_TEXT_UPDATE_PATH_ERROR);
		}
		ob_flush();
		$zip = new ZipArchive;
		$res = $zip->open($destination);
		if($res === TRUE){
			$zip->extractTo($this->root_path."/"); 
			$zip->close();
			unlink($destination);
			echo TVC_TEXT_MAIN_UPDATE_DONE."<br><br>";
			ob_flush();
		}else{
			echo TVC_TEXT_UPDATE_EXTRACTION_ERROR."<br><br>";
			ob_flush();
		}
		if($type == true){
			$source_size = $this->api_url."api/get_update_size/sql/".$update_id; 
			echo TVC_TEXT_PREPARING_SQL_DOWNLOAD."<br>";
			ob_flush();
			echo TVC_TEXT_SQL_UPDATE_SIZE." ".$this->get_remote_filesize($source_size)." ".TVC_TEXT_DONT_REFRESH."<br>";
			ob_flush();
			$temp_progress = '';
			$source = $this->api_url."api/download_update/sql/".$update_id;
			$wp_args = array('body' => json_encode($data_array));	
			$wp_args['method'] = 'POST';
			$this_url = site_url();
			$this_ip = getenv('SERVER_ADDR')?:
				$this->get_ip_from_third_party()?:
				gethostbyname(gethostname());
			$wp_args['headers'] = array(
				'Content-Type' => 'application/json', 
				'LB-API-KEY' => $this->api_key, 
				'LB-URL' => $this_url, 
				'LB-IP' => $this_ip, 
				'LB-LANG' => $this->api_language
			);
			$wp_args['timeout'] = 30;
			echo TVC_TEXT_DOWNLOADING_SQL."<br>";
			ob_flush();
			$result = wp_remote_request($source, $wp_args);
			if(is_wp_error($result)){
				exit(TVC_TEXT_CONNECTION_FAILED);
			}
			$data = $result['body'];
			$http_status = $result['response']['code'];
			if($http_status!=200){
				exit(TVC_TEXT_INVALID_RESPONSE);
			}
			$destination = $this->root_path."/update_sql_".$version.".sql"; 
			$file = $this->write_wp_fs($destination, $data);
			if(!$file){
				exit(TVC_TEXT_UPDATE_PATH_ERROR);
			}
			echo TVC_TEXT_SQL_UPDATE_DONE."<br><br>";
			echo TVC_TEXT_UPDATE_WITH_SQL_DONE;
			ob_flush();
		}else{
			echo TVC_TEXT_UPDATE_WITHOUT_SQL_DONE;
			ob_flush();
		}
		ob_end_flush(); 
	}

	private function get_ip_from_third_party(){
		$wp_args = array('method' => 'GET');	
		$wp_args['timeout'] = 30;
		$result = wp_remote_request('http://ipecho.net/plain', $wp_args);
		if(is_wp_error($result)){
			return false;
		}
		return $result['body'];
	}

	private function get_remote_filesize($url){
		$wp_args = array('method' => 'HEAD');	
		$this_url = site_url();
		$this_ip = getenv('SERVER_ADDR')?:
			$this->get_ip_from_third_party()?:
			gethostbyname(gethostname());
		$wp_args['headers'] = array(
			'Content-Type' => 'application/json', 
			'LB-API-KEY' => $this->api_key, 
			'LB-URL' => $this_url, 
			'LB-IP' => $this_ip, 
			'LB-LANG' => $this->api_language
		);
		$wp_args['timeout'] = 30;
		$result = wp_remote_request($url, $wp_args);
		if(is_wp_error($result)){
			return false;
		}
		$filesize = $result['headers']['content-length'];
		if ($filesize){
			switch ($filesize){
				case $filesize < 1024:
					$size = $filesize .' B'; break;
				case $filesize < 1048576:
					$size = round($filesize / 1024, 2) .' KB'; break;
				case $filesize < 1073741824:
					$size = round($filesize / 1048576, 2) . ' MB'; break;
				case $filesize < 1099511627776:
					$size = round($filesize / 1073741824, 2) . ' GB'; break;
			}
			return $size; 
		}
	}
}
