<?php



/**

 * The class that holds all general (not public/admin) setup functionality.

 *

 * @since		1.0.0

 * @since		1.3.2	Refactored class from object to static methods.

 *

 * @package		TVindoor

 * @subpackage	TVindoor/includes

 * @author		Menno Luitjes | Adapted by Valmy Gomes

 */

class TVindoor_Setup {



	/**

	 * Registers the custom post type for slides and channels.

	 *

	 * @since 	1.0.0

	 * @since	1.3.2	Changed method to static.

	 *

	 * @return void

	 */

	static function register_post_types() {



		register_post_type( TVindoor_Display::post_type_name,

			array(

				'labels' => array(

					'name' => _x( 'Displays', 'display cpt', 'tvindoor' ),

					'singular_name' => _x( 'Display', 'display cpt', 'tvindoor'),

					'add_new' =>  _x( 'Add New', 'display cpt', 'tvindoor'),

					'new_item' => _x( 'New display', 'display cpt', 'tvindoor' ),

					'view_item' => _x( 'View display', 'display cpt', 'tvindoor' ),

					'add_new_item' => _x( 'Add new display', 'display cpt', 'tvindoor' ),

					'edit_item' => _x( 'Edit display', 'display cpt', 'tvindoor' ),

				),

				'public' => true,

				'has_archive' => false,

				'show_in_menu' => 'tvindoor',

				'show_in_admin_bar' => true,

	  			'supports' => array( 'title' ),

	  			'taxonomies' => array(),

	  			'rewrite' => array( 'slug' => 'tvindoor' ),

			)

		);



		register_post_type( TVindoor_Channel::post_type_name,

			array(

				'labels' => array(

					'name' => _x( 'Channels', 'channel cpt', 'tvindoor' ),

					'singular_name' => _x( 'Channel', 'channel cpt', 'tvindoor'),

					'add_new' =>  _x( 'Add New', 'channel cpt', 'tvindoor'),

					'new_item' => _x( 'New channel', 'channel cpt', 'tvindoor' ),

					'view_item' => _x( 'View channel', 'channel cpt', 'tvindoor' ),

					'add_new_item' => _x( 'Add new channel', 'channel cpt', 'tvindoor' ),

					'edit_item' => _x( 'Edit channel', 'channel cpt', 'tvindoor' ),

				),

				'public' => true,

				'has_archive' => false,

				'show_in_menu' => 'tvindoor',

				'show_in_admin_bar' => true,

	  			'supports' => array( 'title' ),

	  			'taxonomies' => array(),

	  			'rewrite' => false,

			)

		);



		register_post_type( TVindoor_Slide::post_type_name,

			array(

				'labels' => array(

					'name' => _x( 'Slides', 'slide cpt', 'tvindoor' ),

					'singular_name' => _x( 'Slide', 'slide cpt', 'tvindoor' ),

					'add_new' =>  _x( 'Add New', 'slide cpt', 'tvindoor'),

					'new_item' => _x( 'New slide', 'slide cpt', 'tvindoor' ),

					'view_item' => _x( 'View slide', 'slide cpt', 'tvindoor' ),

					'add_new_item' => _x( 'Add new slide', 'slide cpt', 'tvindoor' ),

					'edit_item' => _x( 'Edit slide', 'slide cpt', 'tvindoor' ),

				),

				'public' => true,

				'has_archive' => false,

				'show_in_menu' => 'tvindoor',

				'show_in_admin_bar' => true,

	  			'supports' => array( 'title' ),

	  			'taxonomies' => array(),

	  			'rewrite' => false,

			)

		);
		

	}

}

