<?php

/**
 * The class that holds all helper functions for channels.
 *
 * @since		1.4.0
 *
 * @package		TVindoor
 * @subpackage	TVindoor/includes
 * @author		Menno Luitjes | Adapted by Valmy Gomes
 */
class TVindoor_Channels {

	/**
	 * Gets all channel posts.
	 *
	 * @since	1.4.0
	 *
	 * @param	array				$args	Additional args for get_posts().
	 * @return	array of WP_Post			The channel posts.
	 */
	static function get_posts( $args = array() ) {
		$user_id = get_current_user_id();
		$defaults = array(
			'post_type' => TVindoor_Channel::post_type_name,
			'posts_per_page' => -1,
			'author' => $user_id,
		);

		$args = wp_parse_args( $args, $defaults );

		return get_posts( $args );
	}
}
