<?php



/**

 * Defines the admin-specific functionality of the plugin.

 *

 * @since		1.0.0

 * @since		1.3.2	Refactored class from object to static methods.

 *						Switched from using a central TVindoor_Loader class to registering hooks directly

 *						on init of TVindoor, TVindoor_Admin and TVindoor_Public.

 *

 * @package		TVindoor

 * @subpackage	TVindoor/admin

 * @author		Menno Luitjes | Adapted by Valmy Gomes

 */

class TVindoor_Admin {



	/**

	 * Loads dependencies and registers hooks for the admin-facing side of the plugin.

	 *

	 * @since	1.3.2

	 */

	static function init() {

		self::load_dependencies();



		/* TVindoor_Admin */

		add_action( 'admin_enqueue_scripts', array( __CLASS__, 'enqueue_styles' ) );

		add_action( 'admin_enqueue_scripts', array( __CLASS__, 'enqueue_scripts' ) );

		global $tvc_verify_res;

	if($tvc_verify_res['status']){

		add_action( 'admin_menu', array( __CLASS__, 'admin_menu' ) );

	} else {

	    add_action( 'admin_menu', array( __CLASS__, 'tadmin_menu' ) );

	}

		/* TVindoor_Admin_Display */

		add_action( 'admin_enqueue_scripts', array( 'TVindoor_Admin_Display', 'localize_scripts' ) );

		add_action( 'add_meta_boxes', array( 'TVindoor_Admin_Display', 'add_channel_editor_meta_box' ) );

		add_action( 'add_meta_boxes', array( 'TVindoor_Admin_Display', 'add_channel_scheduler_meta_box' ) );

		add_action( 'save_post', array( 'TVindoor_Admin_Display', 'save_display' ) );

		add_filter( 'manage_'.TVindoor_Display::post_type_name.'_posts_columns', array( 'TVindoor_Admin_Display', 'add_channel_columns' ) );

		add_action( 'manage_'.TVindoor_Display::post_type_name.'_posts_custom_column', array( 'TVindoor_Admin_Display', 'do_channel_columns' ), 10, 2 ); 
		
		add_filter( 'manage_'.TVindoor_Display::post_type_name.'_posts_columns', array( 'TVindoor_Admin_Display', 'add_channel_columns' ) );
		
		add_filter('manage_tvindoor_display_posts_columns', 'hs_tvindoor_display_table_head');
			function hs_tvindoor_display_table_head( $columns ) {
  			  $columns['tvindoor_display_token']  = 'Token do Display';
			  return $columns;
			}
		add_action( 'manage_tvindoor_display_posts_custom_column', 'hs_tvindoor_display_table_content', 10, 2 );

			function hs_tvindoor_display_table_content( $column_name, $post_id ) {
    			if( $column_name == 'tvindoor_display_token' ) {
      			$tokendisplay = get_post_meta( $post_id, 'tvindoor_display_token', true );
        		if($tokendisplay != "") {
            	echo $tokendisplay;
      			  }
   			 }
		}
		
		//sincronização de displays
		add_filter('manage_tvindoor_display_posts_columns', 'hy_tvindoor_display_table_head');
			function hy_tvindoor_display_table_head( $columns ) {
  			  $columns['tvindoor_display_sync']  = 'Sincronizado em';
			  return $columns;
			}
		add_action( 'manage_tvindoor_display_posts_custom_column', 'hy_tvindoor_display_table_content', 10, 2 );

			function hy_tvindoor_display_table_content( $column_name, $post_id ) {
    			if( $column_name == 'tvindoor_display_sync' ) {
      			$syncdisplay = get_post_meta( $post_id, 'tvindoor_display_sync', true );
        	//	if($syncdisplay != "") {
            	echo $syncdisplay;
      		//	  }
   			 }
		}

		/* TVindoor_Admin_Channel */

		add_action( 'admin_enqueue_scripts', array( 'TVindoor_Admin_Channel', 'localize_scripts' ) );

		add_action( 'add_meta_boxes', array( 'TVindoor_Admin_Channel', 'add_slides_editor_meta_box' ), 20 );

		add_action( 'add_meta_boxes', array( 'TVindoor_Admin_Channel', 'add_slides_settings_meta_box' ), 40 );

		add_action( 'save_post', array( 'TVindoor_Admin_Channel', 'save_channel' ) );

		add_action( 'wp_ajax_tvindoor_slides_editor_add_slide', array( 'TVindoor_Admin_Channel', 'add_slide_over_ajax' ) );

		add_action( 'wp_ajax_tvindoor_slides_editor_remove_slide', array( 'TVindoor_Admin_Channel', 'remove_slide_over_ajax' ) );

		add_action( 'wp_ajax_tvindoor_slides_editor_reorder_slides', array( 'TVindoor_Admin_Channel', 'reorder_slides_over_ajax' ) );

		add_filter( 'get_sample_permalink_html', array( 'TVindoor_Admin_Channel', 'remove_sample_permalink' ) );

		add_filter( 'manage_'.TVindoor_Channel::post_type_name.'_posts_columns', array( 'TVindoor_Admin_Channel', 'add_slides_count_column' ) );

		add_action( 'manage_'.TVindoor_Channel::post_type_name.'_posts_custom_column', array( 'TVindoor_Admin_Channel', 'do_slides_count_column' ), 10, 2 );



		/* TVindoor_Admin_Slide */

		add_action( 'admin_enqueue_scripts', array( 'TVindoor_Admin_Slide', 'localize_scripts' ) );

		add_action( 'add_meta_boxes', array( 'TVindoor_Admin_Slide', 'add_slide_editor_meta_boxes' ) );

		add_action( 'save_post', array( 'TVindoor_Admin_Slide', 'save_slide' ) );

		add_filter( 'get_sample_permalink_html', array( 'TVindoor_Admin_Slide', 'remove_sample_permalink' ) );

		add_filter( 'manage_'.TVindoor_Slide::post_type_name.'_posts_columns', array( 'TVindoor_Admin_Slide', 'add_slide_format_column' ) );

		add_action( 'manage_'.TVindoor_Slide::post_type_name.'_posts_custom_column', array( 'TVindoor_Admin_Slide', 'do_slide_format_column' ), 10, 2 );



		/* TVindoor_Admin_Preview */

		add_action( 'wp_enqueue_scripts', array( 'TVindoor_Admin_Preview', 'enqueue_scripts' ) );

		add_filter( 'show_admin_bar', array( 'TVindoor_Admin_Preview', 'hide_admin_bar' ) );

		add_action( 'wp_ajax_tvindoor_preview_save_orientation_choice', array( 'TVindoor_Admin_Preview', 'save_orientation_choice' ) );

		add_action( 'wp_ajax_nopriv_tvindoor_preview_save_orientation_choice', array( 'TVindoor_Admin_Preview', 'save_orientation_choice' ) );



		/* TVindoor_Admin_Slide_Format_PDF */

		add_filter( 'wp_image_editors', array( 'TVindoor_Admin_Slide_Format_PDF', 'add_tvindoor_imagick_image_editor' ) );

		add_action( 'delete_attachment', array( 'TVindoor_Admin_Slide_Format_PDF', 'delete_pdf_images_for_attachment' ) );

		add_action( 'admin_notices', array( 'TVindoor_Admin_Slide_Format_PDF', 'display_admin_notice' ) );
		
			/* TVindoor_Admin_Serverless */
		
		add_action( 'add_meta_boxes', array( 'TVindoor_Admin_Serverless_Radio', 'add_serverless_meta_box' ), 20 );

	}



	/**

	 * Adds the top-level TVindoor admin menu item.

	 *

	 * @since	1.0.0

	 * @since	1.3.2	Changed method to static.

	 *					Added context for translations.

	 * @since	1.5.1	Improved the context of the translatable string 'TVindoor' to make translation easier.

	 */

	static function admin_menu() {

		add_menu_page(

			_x( __( 'RadioTV Indoor', 'tvindoor' ), 'plugin name in admin menu', 'tvindoor' ),

			_x( __( 'RadioTV Indoor', 'tvindoor' ), 'plugin name in admin menu', 'tvindoor' ),

			'edit_posts',

			'tvindoor',

			array(),

			'dashicons-welcome-view-site',

			31

		);

	//	 add_submenu_page( 'tvindoor', __( 'RadioTV Indoor', 'tvindoor' ), __( 'Setting Radio', 'tvindoor' ), 'manage_options', 'radio-settings','radiotvindoor_radio_settings_page');

	    add_submenu_page( 'tvindoor', __( 'RadioTV Indoor', 'tvindoor' ), __( 'License of RadioTV Indoor', 'tvindoor' ), 'manage_options', 'radiotvindoor','radiotvindoor_plugin_page');

	}

	

	static function tadmin_menu() {

	    add_menu_page( __( 'RadioTV Indoor', 'tvindoor' ), __( 'RadioTV Indoor', 'tvindoor' ), 'manage_options','radiotvindoor', 'radiotvindoor_plugin_page', 'dashicons-welcome-view-site', 31  );

		add_submenu_page( 'tvindoor', __( 'RadioTV Indoor', 'tvindoor' ), __( 'License of RadioTV Indoor', 'tvindoor' ), 'manage_options', 'radiotvindoor','radiotvindoor_plugin_page');

	}



	/**

	 * Enqueues the JavaScript for the admin area.

	 *

	 * @since	1.0.0

	 * @since	1.2.5	Register scripts before they are enqueued.

	 *					Makes it possible to enqueue TVindoor scripts outside of the TVindoor plugin.

	 *					Changed handle of script to {plugin_name}-admin.

	 * @since	1.3.2	Changed method to static.

	 */

	static function enqueue_scripts() {



		wp_register_script( TVindoor::get_plugin_name() . '-admin', plugin_dir_url( __FILE__ ) . 'js/tvindoor-admin-min.js', array( 'jquery', 'jquery-ui-sortable' ), TVindoor::get_version(), false );

		wp_enqueue_script( TVindoor::get_plugin_name() . '-admin' );

	}



	/**

	 * Enqueues the stylesheets for the admin area.

	 *

	 * @since	1.0.0

	 * @since	1.3.2	Changed method to static.

	 */

	static function enqueue_styles() {



		wp_enqueue_style( TVindoor::get_plugin_name(), plugin_dir_url( __FILE__ ) . 'css/tvindoor-admin.css', array(), TVindoor::get_version(), 'all' );

	}



	/**

	 * Loads the required dependencies for the admin-facing side of the plugin.

	 *

	 * @since	1.3.2

	 * @since	1.4.0	Included admin/class-tvindoor-admin-slide-background-image.php.

	 *					Included admin/class-tvindoor-admin-slide-background-video.php.

	 *					Removed include admin/class-tvindoor-admin-slide-format-video.php.

	 * @since	1.6.0	Included the HTML5 Video slide background admin.

	 * @since	1.7.0	Included the Upcoming Productions slide background admin.

	 *

	 * @access	private

	 */

	private static function load_dependencies() {



		/**

		 * Admin area functionality for display, channel and slide.

		 */

		require_once TVINDOOR_PLUGIN_PATH . 'admin/class-tvindoor-admin-display.php';

		require_once TVINDOOR_PLUGIN_PATH . 'admin/class-tvindoor-admin-channel.php';

		require_once TVINDOOR_PLUGIN_PATH . 'admin/class-tvindoor-admin-slide.php';

		require_once TVINDOOR_PLUGIN_PATH . 'admin/class-tvindoor-admin-preview.php';


		/* Playlist Serverless by Valmy Gomes and Sandeep Verma in 23/07/2021. */
		require_once TVINDOOR_PLUGIN_PATH . 'admin/class-tvindoor-serverless.php';

		/**

		 * Admin area functionality for specific slide backgrounds.

		 */

		require_once TVINDOOR_PLUGIN_PATH . 'admin/class-tvindoor-admin-slide-background-image.php';

		require_once TVINDOOR_PLUGIN_PATH . 'admin/class-tvindoor-admin-slide-background-video.php';

		require_once TVINDOOR_PLUGIN_PATH . 'admin/class-tvindoor-admin-slide-background-html5-video.php';



		/**

		 * Admin area functionality for specific slide formats.

		 */

		require_once TVINDOOR_PLUGIN_PATH . 'admin/class-tvindoor-admin-slide-format-iframe.php';

		require_once TVINDOOR_PLUGIN_PATH . 'admin/class-tvindoor-admin-slide-format-pdf.php';

		require_once TVINDOOR_PLUGIN_PATH . 'admin/class-tvindoor-admin-slide-format-post.php';

		require_once TVINDOOR_PLUGIN_PATH . 'admin/class-tvindoor-admin-slide-format-production.php';

		require_once TVINDOOR_PLUGIN_PATH . 'admin/class-tvindoor-admin-slide-format-recent-posts.php';

		require_once TVINDOOR_PLUGIN_PATH . 'admin/class-tvindoor-admin-slide-format-text.php';

		require_once TVINDOOR_PLUGIN_PATH . 'admin/class-tvindoor-admin-slide-format-upcoming-productions.php';

	}

}

